﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class ThumbnailQuality : UserControl,IControl,ICorrespondenceOS
    {
        private ThumbnailQualityController thumbnailQualityController;

        public ThumbnailQuality()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,  
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetThumbnailQualityValue(int i)
        {
            textBox1.Text = i.ToString();
        }


        public int GetThumbnailQualityValue()
        {
            return Convert.ToInt32(textBox1.Text);
        }

        #region IControl メンバ

        public void Apply()
        {
            thumbnailQualityController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return thumbnailQualityController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void ThumbnailQuality_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            thumbnailQualityController = new ThumbnailQualityController(this,
                                                                        (IThumbnailQualityStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new ThumbnailQualityDefaultStrategy()
                                                                                 }));
            thumbnailQualityController.Read();
        }
    }
}
